#ifndef _PCI_BACKPORT_H
#define _PCI_BACKPORT_H

#include_next <linux/pci.h>

/*
 * pci_find_next_capability - Find next capability after current position
 * @dev: PCI device to query
 * @pos: Position to search from
 * @cap: capability code
 */
static inline int pci_find_next_capability(struct pci_dev *dev, u8 pos, int cap)
{
	u8 id;
	int ttl = 48;
	int ret;

	while (ttl--) {
		pci_read_config_byte(dev, pos + PCI_CAP_LIST_NEXT, &pos);
		pos &= ~3;
		if (pos < 0x40)
			break;
		pci_read_config_byte(dev, pos + PCI_CAP_LIST_ID, &id);
		if (id == 0xff)
			break;
		if (id == cap) {
			ret = pos;
			goto bail;
		}
	}

	ret = 0;

bail:
	return ret;
}

#endif /* _PCI_BACKPORT_H */
